package oddeven;

import java.io.IOException;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Mapper;

public class mapper  extends Mapper<LongWritable, Text, Text, IntWritable> {

    @Override
    public void map(LongWritable key, Text value, Context context) throws IOException, InterruptedException {
        String[] numbers = value.toString().split("\\s+");  // Split input line by spaces

        for (String numStr : numbers) {
            try {
                int num = Integer.parseInt(numStr.trim());

                // Prime number check
                if (isPrime(num)) {
                    context.write(new Text("Prime"), new IntWritable(num));
                } else {
                    context.write(new Text("Not Prime"), new IntWritable(num));
                }

                // Odd or Even check
                if (num % 2 == 0) {
                    context.write(new Text("Even"), new IntWritable(num));
                } else {
                    context.write(new Text("Odd"), new IntWritable(num));
                }

            } catch (NumberFormatException e) {
                // Ignore non-numeric input
            }
        }
    }

    private boolean isPrime(int num) {
        if (num < 2) return false;
        if (num == 2) return true;
        if (num % 2 == 0) return false;

        for (int i = 3; i <= Math.sqrt(num); i += 2) {
            if (num % i == 0) {
                return false;
            }
        }
        return true;
    }
}

