package earthquake;

import java.io.IOException;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapred.MapReduceBase;
import org.apache.hadoop.mapred.Mapper;
import org.apache.hadoop.mapred.OutputCollector;
import org.apache.hadoop.mapred.Reporter;

public class mapper extends MapReduceBase implements Mapper<LongWritable, Text, Text, DoubleWritable> {

    public void map(LongWritable key, Text value, OutputCollector<Text, DoubleWritable> output, Reporter reporter) throws IOException {
        String lineStr = value.toString().trim();

        // Skip empty lines
        if (lineStr.isEmpty()) return;

        String[] line = lineStr.split(",");

        // Guard: not enough columns
        if (line.length <= 11) return;

        // Header detection - using contains and trimming
        if (line[7].trim().equalsIgnoreCase("Depth")) return;

        try {
            double longitude = Double.parseDouble(line[7].trim());
            String location = line[11].trim();
            output.collect(new Text(location), new DoubleWritable(longitude));
        } catch (NumberFormatException e) {
            // Optionally log: System.err.println("Bad data: " + lineStr);
        }
    }
}

